namespace Microsoft.Samples.PlanMyNight.AddIns.Share.Tests.Tests
{
    using System.ComponentModel.Composition.Hosting;
    using System.Linq;
    using System.Web.Routing;
    using Microsoft.Samples.PlanMyNight.AddIns.Share;
    using Microsoft.Samples.PlanMyNight.Infrastructure;
    using Microsoft.VisualStudio.TestTools.UnitTesting;

    [TestClass]
    public class SharingContextualActionsExportFixture
    {
        [TestMethod]
        public void ShouldExportMefConsumableRouteForLinking()
        {
            var catalog = new TypeCatalog(typeof(SharingContextualActionsExport));
            var container = new CompositionContainer(catalog);

            var actual = container.GetExports<ExtensionLink>();

            Assert.AreEqual(2, actual.Count());
        }

        [TestMethod]
        public void ShouldExportMefConsumableRouteForToolbox()
        {
            var catalog = new TypeCatalog(typeof(SharingContextualActionsExport));
            var container = new CompositionContainer(catalog);

            var actual = container.GetExports<RouteValueDictionary>();

            Assert.AreEqual(2, actual.Count());
        }

        [TestMethod]
        public void ShouldExportMefConsumableMetadataForActivityExtensionSite()
        {
            var catalog = new TypeCatalog(typeof(SharingContextualActionsExport));
            var container = new CompositionContainer(catalog);

            var actual = container.GetExports<ExtensionLink, IExtensionSiteMetadata>();

            Assert.AreEqual(2, actual.Count());
            Assert.IsTrue(actual.Any(e => e.Metadata.TargetExtensionSite == "SharingLinks"));
            Assert.IsTrue(actual.Any(e => e.Value.LinkText == "Shorten URL"));
            Assert.IsTrue(actual.Any(e => e.Metadata.TargetExtensionSite == "SharingLinks"));
            Assert.IsTrue(actual.Any(e => e.Value.LinkText == "Share"));
        }

        [TestMethod]
        public void ShouldExportMefConsumableMetadataForToolboxRendering()
        {
            var catalog = new TypeCatalog(typeof(SharingContextualActionsExport));
            var container = new CompositionContainer(catalog);

            var actual = container.GetExports<RouteValueDictionary, IExtensionSiteMetadata>();

            Assert.AreEqual(2, actual.Count());
            Assert.IsTrue(actual.Any(e => (string)e.Value["controller"] == "Sharing"));
            Assert.IsTrue(actual.Any(e => (string)e.Value["action"] == "ShortUrlToolbox"));
            Assert.IsTrue(actual.Any(e => (string)e.Value["controller"] == "Sharing"));
            Assert.IsTrue(actual.Any(e => (string)e.Value["action"] == "ShareToolbox"));
        }
    }
}
